library(nls2)
library(ggplot2)

prelec_weighting <- function(p, alpha) {
  exp(-(-log(p))^alpha)
}
# Generate a sequence of objective probabilities
prob_seq <- seq(0.001, 1, length.out = 100)

# Calculate subjective probabilities using the Prelec function
subj_prob <- prelec_weighting(prob_seq, alpha_est)

# Create a dataframe for plotting
plot_data <- data.frame(ObjectiveProb = prob_seq, SubjectiveProb = subj_prob)

result_D2 <- nls2(D2 ~ prelec_weighting(D2_Probability, alpha), 
                  start = list(alpha = 0.45), data = Honors_Thesis_Data_5_, algorithm = "brute-force")

result_D3 <- nls2(D3 ~ prelec_weighting(D3_Probability, alpha), 
                  start = list(alpha = 0.45), data = Honors_Thesis_Data_5_, algorithm = "brute-force")


print(summary(result_D2))
print(summary(result_D3))
decision_data <- data.frame(Prob = c(0.098, 0.1, 0.0098, 0.01), DecisionProp = c(0.5814, 0.4186, 0.2558, 0.7442))


# Estimated alpha value (replace with your actual estimate)
alpha_est <- 0.61

# Prelec Probability Weighting Function
prelec_weighting <- function(p, alpha) {
  exp(-(-log(p))^alpha)
}

# Generating a sequence of objective probabilities for plotting
prob_seq <- seq(0.001, 1, length.out = 1000)
subj_prob <- prelec_weighting(prob_seq, alpha_est)

# Creating a data frame for the plot
plot_data <- data.frame(ObjectiveProb = prob_seq, SubjectiveProb = subj_prob)

# Decision points from your experiment
decision_points <- data.frame(
  Probability = c(0.098, 0.1, 0.0098, 0.01),
  Type = factor(c('D2', 'D2', 'D3', 'D3'), levels = c('D2', 'D3')),
  Preference = c('Fixed', 'CE', 'Fixed', 'CE') # This could represent fixed $3 vs. CE
)

decision_data <- data.frame(
  Probability = c(0.098, 0.1, 0.0098, 0.01),
  DecisionType = c('D2', 'D2', 'D3', 'D3'),
  ProportionCE = c(0.5813, 0.4186, 0.2558, 0.7442) # Proportion choosing CE
)

sbp <- ggplot(d2_data, aes(x = "", y = Proportion, fill = Color)) +
  geom_bar(stat = "identity", width = 1) +
  scale_fill_identity() +
  coord_polar(theta = "y") + # Optional: if you prefer a pie chart representation
  labs(x = NULL, y = NULL, fill = "Decision Type", 
       title = "Proportions of Decisions for D2",
       subtitle = "Orange: Prefer Fixed $3, Blue: Prefer CE") +
  theme_void() + # Removes most plot elements for clarity
  theme(legend.position = "bottom") +
  guides(fill = guide_legend(override.aes = list(color = NA)))

d2_data <- data.frame(
  Choice = c("Prefer Fixed $3", "Prefer CE"),
  Proportion = c(0.45, 0.55), # Example proportions
  Color = c("orange", "steelblue")
)
p_sci <- ggplot(plot_data, aes(x = ObjectiveProb, y = SubjectiveProb)) +
  geom_line(linetype = "solid", size = 1.2) +  # Solid line for the main function
  geom_point(data = decision_points, aes(x = Probability, y = prelec_weighting(Probability, alpha_est),
                                         shape = Type), size = 4, stroke = 2) +
  geom_abline(intercept = 0, slope = 1, linetype = "dashed", color = "black", size = 1) +
  scale_shape_manual(values = c('D2' = 17, 'D3' = 18)) + # Clear shape distinction
  labs(x = 'Objective Probability', y = 'Weighted (Subjective) Probability', 
       title = 'Decision Points on the Prelec Probability Weighting Function',
       subtitle = sprintf('Prelec Function with α = %.2f', alpha_est),
       caption = "Note: Solid line represents the Prelec function. \nShapes indicate experiment decisions.") +
  theme_classic(base_size = 14) + # A classic theme for scientific plots
  theme(legend.title = element_blank(),
        legend.position = "right",
        plot.title = element_text(face = "bold", size = 16),
        plot.subtitle = element_text(size = 14),
        axis.title = element_text(size = 14),
        axis.text = element_text(size = 12),
        legend.text = element_text(size = 12),
        legend.key = element_blank(), # Remove background from legend symbols
        panel.border = element_rect(colour = "black", fill=NA, size=1)) +
  guides(shape = guide_legend(override.aes = list(size = 6, stroke = 1.5))) # Adjust guide settings for clarity

# Display the refined plot
print(p_sci)

# Bar plot of proportions
bp <- ggplot(decision_data, aes(x = as.factor(Probability), y = ProportionCE, fill = DecisionType)) +
  geom_bar(stat = "identity", position = position_dodge()) +
  scale_fill_manual(values = c('D2' = 'steelblue', 'D3' = 'darkorange')) +
  labs(x = 'Probability', y = 'Proportion Choosing CE', 
       title = 'Proportion of Participants Choosing CE by Probability',
       subtitle = 'Separated by Decision Type (D2 vs D3)') +
  theme_minimal() +
  theme(axis.text.x = element_text(angle = 45, hjust = 1))

print(bp)
print(sbp)

